//
//  ConfirmFinalTransactionViewController.swift
//  OnlineBanking
//
//  Created by Marvin Kowalewski on 13.02.23.
//

import UIKit
import Firebase 


class ConfirmFinalTransactionViewController : UIViewController, UITextFieldDelegate {
    
    @IBOutlet var cancelButton: UIButton!
    
    @IBOutlet var PINTextField: UITextField!
    
    fileprivate let circleDigit1 = UIView()
    fileprivate let circleDigit2 = UIView()
    fileprivate let circleDigit3 = UIView()
    fileprivate let circleDigit4 = UIView()
    fileprivate let circleDigit5 = UIView()
    fileprivate let circleDigit6 = UIView()
    

    @IBOutlet var d1: UILabel!
    @IBOutlet var d2: UILabel!
    @IBOutlet var d3: UILabel!
    @IBOutlet var d4: UILabel!
    @IBOutlet var d5: UILabel!
    @IBOutlet var d6: UILabel!
    
    
    @IBOutlet var detailsInformationLabel: UILabel!
    

    @IBOutlet var errorLabel: UILabel!
    
    
    fileprivate var _kbSize:CGSize!
    
    
    override func viewDidLoad() {
        
        super.viewDidLoad()
        
        // design top bar text font and color
        UINavigationBar.appearance().titleTextAttributes = [.foregroundColor : UIColor.white,
                                                            .font : Fonts.mediumFontWithSize(size: 18)]
        
        if !developerMode {
            PINTextField.isHidden = true
        }
        
        // design stuff...
        cancelButton.titleLabel?.font = Fonts.lightFontWithSize(size: 16)
        errorLabel.alpha = 0
        
        errorLabel.font = Fonts.lightFontWithSize(size: 16)
        errorLabel.textColor = Colors.carmine
        
        // Register keyboard notification
         NotificationCenter.default.addObserver(self, selector: #selector(self.keyboardWillShow(_:)), name: UIResponder.keyboardWillShowNotification, object: nil)
        
        PINTextField.isUserInteractionEnabled = true
        PINTextField.becomeFirstResponder()
        PINTextField.text = ""
        //PINTextField.keyboardAppearance = .default
        
        //PINTextField.delegate = self // required for observing whether user typed something...
        PINTextField.addTarget(self, action: #selector(self.textFieldDidChange(textField:)), for: UIControl.Event.editingChanged)

        detailsInformationLabel.font = Fonts.lightFontWithSize(size: 16)
        detailsInformationLabel.text = "Please authorize the transfer\n using your app PIN."
        
        // draw PIN dots
        drawPIN()
    }
    
    // activate gradient background
    override func viewWillAppear(_ animated: Bool) {
        setGradientBackground()
        super.viewWillAppear(animated)
    }
    
    func setGradientBackground() {

        // change gradient background color
        let colorTop =  UIColor(red: 55/255.0, green: 85/255.0, blue: 135/255.0, alpha: 1.0).cgColor
        let  colorBottom = UIColor(red: 67.0/255.0, green: 114.0/255.0, blue: 196.0/255.0, alpha: 1.0).cgColor
                    
        let gradientLayer = CAGradientLayer()
        gradientLayer.colors = [colorTop, colorBottom]
        gradientLayer.locations = [0.0, 0.7]
        gradientLayer.frame = self.view.bounds
                
        self.view.layer.insertSublayer(gradientLayer, at:0)
    }
    
    func drawPIN() {
        let size:CGFloat = 12.5
        circleDigit1.bounds = CGRect(x: 0, y: 0, width: size, height: size)
        circleDigit1.layer.cornerRadius = size / 2
        circleDigit1.layer.borderWidth = 1
        circleDigit1.layer.borderColor = UIColor.white.cgColor
        circleDigit1.layer.backgroundColor = UIColor.clear.cgColor
        
        circleDigit2.bounds = CGRect(x: 0, y: 0, width: size, height: size)
        circleDigit2.layer.cornerRadius = size / 2
        circleDigit2.layer.borderWidth = 1
        circleDigit2.layer.borderColor = UIColor.white.cgColor
        circleDigit2.layer.backgroundColor = UIColor.clear.cgColor
        
        circleDigit3.bounds = CGRect(x: 0, y: 0, width: size, height: size)
        circleDigit3.layer.cornerRadius = size / 2
        circleDigit3.layer.borderWidth = 1
        circleDigit3.layer.borderColor = UIColor.white.cgColor
        circleDigit3.layer.backgroundColor = UIColor.clear.cgColor
        
        circleDigit4.bounds = CGRect(x: 0, y: 0, width: size, height: size)
        circleDigit4.layer.cornerRadius = size / 2
        circleDigit4.layer.borderWidth = 1
        circleDigit4.layer.borderColor = UIColor.white.cgColor
        circleDigit4.layer.backgroundColor = UIColor.clear.cgColor
        
        circleDigit5.bounds = CGRect(x: 0, y: 0, width: size, height: size)
        circleDigit5.layer.cornerRadius = size / 2
        circleDigit5.layer.borderWidth = 1
        circleDigit5.layer.borderColor = UIColor.white.cgColor
        circleDigit5.layer.backgroundColor = UIColor.clear.cgColor
        
        circleDigit6.bounds = CGRect(x: 0, y: 0, width: size, height: size)
        circleDigit6.layer.cornerRadius = size / 2
        circleDigit6.layer.borderWidth = 1
        circleDigit6.layer.borderColor = UIColor.white.cgColor
        circleDigit6.layer.backgroundColor = UIColor.clear.cgColor
        
        
        view.addSubview(circleDigit1)
        view.addSubview(circleDigit2)
        view.addSubview(circleDigit3)
        view.addSubview(circleDigit4)
        view.addSubview(circleDigit5)
        view.addSubview(circleDigit6)
        
        
        // center balance stack view *horizontally* in view
        //stackView.translatesAutoresizingMaskIntoConstraints = false
        //stackView.centerXAnchor.constraint(equalTo: self.view.centerXAnchor).isActive = true
        //stackView.centerYAnchor.constraint(equalTo: self.view.centerYAnchor).isActive = true
        
        d1.translatesAutoresizingMaskIntoConstraints = false
        d1.centerXAnchor.constraint(equalTo: self.view.centerXAnchor, constant: -75).isActive = true
        //d1.topAnchor.constraint(equalTo: self.view.topAnchor, constant: +100).isActive = true
        
        d2.translatesAutoresizingMaskIntoConstraints = false
        d2.centerXAnchor.constraint(equalTo: self.view.centerXAnchor, constant: -45).isActive = true
        //d2.topAnchor.constraint(equalTo: self.view.topAnchor, constant: +100).isActive = true

        d3.translatesAutoresizingMaskIntoConstraints = false
        d3.centerXAnchor.constraint(equalTo: self.view.centerXAnchor, constant: -15).isActive = true
        //d3.topAnchor.constraint(equalTo: self.view.topAnchor, constant: +100).isActive = true
        
        d4.translatesAutoresizingMaskIntoConstraints = false
        d4.centerXAnchor.constraint(equalTo: self.view.centerXAnchor, constant: 15).isActive = true
        //d4.topAnchor.constraint(equalTo: self.view.topAnchor, constant: +100).isActive = true
        
        d5.translatesAutoresizingMaskIntoConstraints = false
        d5.centerXAnchor.constraint(equalTo: self.view.centerXAnchor, constant: 45).isActive = true
        //d5.topAnchor.constraint(equalTo: self.view.topAnchor, constant: +100).isActive = true
        
        d6.translatesAutoresizingMaskIntoConstraints = false
        d6.centerXAnchor.constraint(equalTo: self.view.centerXAnchor, constant: 75).isActive = true

        
        d1.insertSubview(circleDigit1, aboveSubview: d1)
        d1.text = ""
        d1.textAlignment = .center
        
        d2.insertSubview(circleDigit2, aboveSubview: d2)
        d2.text = ""
        d2.textAlignment = .center
        
        d3.insertSubview(circleDigit3, aboveSubview: d3)
        d3.text = ""
        d3.textAlignment = .center
        
        d4.insertSubview(circleDigit4, aboveSubview: d4)
        d4.text = ""
        d4.textAlignment = .center
        
        d5.insertSubview(circleDigit5, aboveSubview: d5)
        d5.text = ""
        d5.textAlignment = .center
        
        d6.insertSubview(circleDigit6, aboveSubview: d6)
        d6.text = ""
        d6.textAlignment = .center
    }
    
    // animate shaked PIN dots
    func shakePINField (PINfield: UIView) {
        let animation = CABasicAnimation(keyPath: "position")
        animation.duration = 0.07
        animation.repeatCount = 3
        animation.autoreverses = true
        animation.fromValue = NSValue(cgPoint: CGPoint(x: PINfield.center.x - 5, y: PINfield.center.y))
        animation.toValue = NSValue(cgPoint: CGPoint(x: PINfield.center.x + 5, y: PINfield.center.y))
        PINfield.layer.add(animation, forKey: "position")
    }
    
    // store user data based in firebase cloud firestore database
    func storeUserData(userTransactionRecipient: String, userTransactionIBAN: String, userTransactionPurpose: String, userTransactionAmount: String) {
        
        // get time for both
        TimerManager.shared.stopTimer_AfterLogin()
        TimerManager.shared.stopTimer_NewTransaction()
        
        let timeInSeconds_AfterLogin : String = TimerManager.shared.getElapsedTime1AsString_AfterLogin()
        print(timeInSeconds_AfterLogin)
        let timeInSeconds_NewTransaction : String = TimerManager.shared.getElapsedTime2AsString_NewTransaction()
        print(timeInSeconds_NewTransaction)
        
        
        // see https://www.youtube.com/watch?v=qA9L3_cK9Z0
        let db = Firestore.firestore()
        
        let docRef = db.collection(qualtricsOnlineBankingDBPublic).document("\(appPINPublic)")
        docRef.getDocument{(document, error) in
            if let document = document, document.exists {
                
                let dateFormatter = DateFormatter()
                dateFormatter.dateFormat = "yyyy-MM-dd'T'HH:mm:ssZ"
                let timestampAppTransactionTimestamp = dateFormatter.string(from: Date())
                let timestampAppTransactionString = String(timestampAppTransactionTimestamp)
                print("Timestamp App Transaction: \(timestampAppTransactionString)")
                
                // check if user w/ specific appPIN has already done the *first* transaction
                if lockDBForScenarioAppPIN_TransactionSuccessfulPublic == false {
                    
                    // lock "App Transaction" Firestore DB to prevent adding multiple transaction there (happening in changing "Qualtrics" Firestore DB field value "")
                    db.collection(qualtricsOnlineBankingDBPublic).document(appPINPublic).setData(["lockDBForScenarioAppPIN_TransactionSuccessful" : true, "lockAppPIN_SurveyIncomplete" : true], merge: true)
                    
                    // store data in scenario specific database collection as a new document but w/ random document ID
                    db.collection(appOnlineBankingScenarioDBPublic+String(scenarioPublic)).addDocument(data: ["appPIN" : appPINPublic,
                                            "userID" : userIDPublic,
                                            "userTransactionRecipient" : userTransactionRecipient,
                                            "userTransactionIBAN" : userTransactionIBAN,
                                            "userTransactionPurpose" : userTransactionPurpose,
                                            "userTransactionAmount" : userTransactionAmount,
                                            "userTransactionTyposIBAN" : transactionTypoIBANPublic,
                                            "userTotalTransactionTime" : timeInSeconds_NewTransaction,
                                            "userTotalLoginTime" : timeInSeconds_AfterLogin,
                                            "userWrongPINCounter" : wrongPINCounterPublic,
                                            "timestamp_Qualtrics" : timestamp_QualtricsPublic,
                                            "timestamp_AppTransaction" : timestampAppTransactionString,
                                            "device" : "iPhone"]) { (error) in
                        
                        if(error != nil) {
                            print("Error saving user data in Firestore DB :-(")
                        }
                    }
                    
                    print("Done. Saved user transaction data successfully in Firestore DB!")
                    
                    
                    // reset new transaction timer
                    TimerManager.shared.resetTimer_NewTransaction()
                    
                    /* ### Database for user "appPIN" is now locked! ### */
                    // -> is set above: lockDatabaseForAppPIN == true <-
                    
                    /* ### User cannot browse through the views anymore! ### */
                    lockAppPIN_SurveyIncompletePublic = true
                    /* ### User cannot write in this DB anymore! ### */
                    lockDBForScenarioAppPIN_TransactionSuccessfulPublic = true
                    
                    /* ### Store user transaction data on individual smartphone ### */
                    let defaults = UserDefaults.standard
                    defaults.set(true, forKey: "TransactionShowInGiroAccount")

                    defaults.set(userTransactionRecipient, forKey: "UserTransactionRecipient")
                    defaults.set(userTransactionIBAN, forKey: "userTransactionIBAN")
                    
                    let userTransactionAmountFloat : Float = round(self.convertUsertransactionAmountStringToFloat(string: userTransactionAmount) * 100) / 100.0
                    
                    defaults.set(userTransactionAmountFloat, forKey: "userTransactionAmount")
                    defaults.set(userTransactionPurpose, forKey: "userTransactionPurpose")
                    
                    // from now on allow both transaction types and real world IBANs
                    let allowBothTransactionTypesAndRealWorldIBANs : Bool = true
                    defaults.set(allowBothTransactionTypesAndRealWorldIBANs, forKey: "allowBothTransactionTypesAndRealWorldIBANs")
                    
                    // Fallback...
                    if #available(iOS 15, *) {
                        defaults.set(Date.now, forKey: "TransactionTime")
                    } else {
                        defaults.set(Date(), forKey: "TransactionTime")
                    }

                    
                    let roundedAmountGiroAccount : Float = round((amountGiroAccountPublic - userTransactionAmountFloat) * 100) / 100.0
                    defaults.set(roundedAmountGiroAccount, forKey: "amountGiroAccount")
                    print("Refresh giro account amount:")
                    print(userTransactionAmountFloat)
                    print(amountGiroAccountPublic - userTransactionAmountFloat)
                }
                
                // only used as backup, if user w/ specific appPIN wants to conduct a second transaction (i.e., main transaction is alrady done)
                //lockDBForScenarioAppPIN_TransactionSuccessfulPublic == true
                else {
                    
                    
                    print ("Data for user -\(appPINPublic)- was already written to app_onlinebanking_scenario\(scenarioPublic) Firestore DB")
                    // store data in scenario specific BACKUP database collection as a new document but w/ random ID
                    db.collection(appOnlineBankingScenarioDBBackupPublic+String(scenarioPublic)+"_backup").addDocument(data: ["appPIN" : appPINPublic,
                        "userID" : userIDPublic, "userTransactionRecipient" : userTransactionRecipient,
                        "userTransactionIBAN" : userTransactionIBAN, "userTransactionPurpose" : userTransactionPurpose,
                         "userTransactionAmount" : userTransactionAmount,
                         "timestamp_Qualtrics" : timestamp_QualtricsPublic,
                         "timestamp_AppTransaction" : timestampAppTransactionString,
                         "device" : "iPhone"]) { (error) in
                        
                        if(error != nil) {
                            print("Error saving user data in BACKUP Firestore DB :-(")
                        }
                    }
                    
                    print("Done. Saved user transaction data successfully in BACKUP Firestore DB!")
                }
            } else {
                print("PIN not found. Maybe DB error occured in the meantime? Looks not good...")
            }
        }
    }
    
    
    func convertUsertransactionAmountStringToFloat(string : String) -> Float {
        var str : String = ""
        if(string.contains(",")) {
            str = (string.replacingOccurrences(of: ".", with: "")).replacingOccurrences(of: ",", with: ".")
        } else {
            str = string.replacingOccurrences(of: ",", with: ".")
        }
        
        var float: Float = 0.00

        guard let convertedFloat = Float(str) else {
            float = 0.00
            print("Ungültiger String")
            return float
        }

        float = convertedFloat
        print(float)
        
        return float
    }
    

    // https://stackoverflow.com/questions/30656501/how-to-do-a-live-uitextfield-count-while-typing-swift
    @objc func textFieldDidChange(textField : UITextField){
        if self.PINTextField.text?.count == 1 {
            circleDigit1.layer.backgroundColor = UIColor.white.cgColor
            circleDigit2.backgroundColor = UIColor.clear
            circleDigit3.backgroundColor = UIColor.clear
            circleDigit4.backgroundColor = UIColor.clear
            circleDigit5.backgroundColor = UIColor.clear
            circleDigit6.backgroundColor = UIColor.clear
            circleDigit1.layer.borderColor = UIColor.white.cgColor
            circleDigit2.layer.borderColor = UIColor.white.cgColor
            circleDigit3.layer.borderColor = UIColor.white.cgColor
            circleDigit4.layer.borderColor = UIColor.white.cgColor
            circleDigit5.layer.borderColor = UIColor.white.cgColor
            circleDigit6.layer.borderColor = UIColor.white.cgColor
        } else if self.PINTextField.text?.count == 2 {
            circleDigit2.layer.backgroundColor = UIColor.white.cgColor
        } else if self.PINTextField.text?.count == 3 {
            circleDigit3.layer.backgroundColor = UIColor.white.cgColor
        } else if self.PINTextField.text?.count == 4 {
            circleDigit4.layer.backgroundColor = UIColor.white.cgColor
        } else if self.PINTextField.text?.count == 5 {
            circleDigit5.layer.backgroundColor = UIColor.white.cgColor
        } else if self.PINTextField.text?.count == 6 {
            if (appPINPublic != PINTextField.text) {
                self.PINTextField.isUserInteractionEnabled = false
                let redColor = UIColor(red: 120.0/255.0, green: 22/255.0, blue: 13/255.0, alpha: 1.0)

                circleDigit1.backgroundColor = redColor
                circleDigit1.layer.borderColor = UIColor.clear.cgColor
                self.shakePINField(PINfield: circleDigit1)
                circleDigit2.backgroundColor = redColor
                circleDigit2.layer.borderColor = UIColor.clear.cgColor
                self.shakePINField(PINfield: circleDigit2)
                circleDigit3.backgroundColor = redColor
                circleDigit3.layer.borderColor = UIColor.clear.cgColor
                self.shakePINField(PINfield: circleDigit3)
                circleDigit4.backgroundColor = redColor
                circleDigit4.layer.borderColor = UIColor.clear.cgColor
                self.shakePINField(PINfield: circleDigit4)
                circleDigit5.backgroundColor = redColor
                circleDigit5.layer.borderColor = UIColor.clear.cgColor
                self.shakePINField(PINfield: circleDigit5)
                circleDigit6.backgroundColor = redColor
                circleDigit6.layer.borderColor = UIColor.clear.cgColor
                self.shakePINField(PINfield: circleDigit6)
    
                
                // vibrate device caused by wrong PIN
                let generator = UIImpactFeedbackGenerator(style: .medium)
                generator.impactOccurred()
                DispatchQueue.main.asyncAfter(deadline: .now() + 0.1) {
                    generator.impactOccurred()
                }
                DispatchQueue.main.asyncAfter(deadline: .now() + 0.2) {
                    generator.impactOccurred()
                }
                DispatchQueue.main.asyncAfter(deadline: .now() + 0.3) {
                    generator.impactOccurred()
                }
                
                DispatchQueue.main.asyncAfter(deadline: .now() + 1) {
                    self.circleDigit1.backgroundColor = UIColor.clear
                    self.circleDigit2.backgroundColor = UIColor.clear
                    self.circleDigit3.backgroundColor = UIColor.clear
                    self.circleDigit4.backgroundColor = UIColor.clear
                    self.circleDigit5.backgroundColor = UIColor.clear
                    self.circleDigit6.backgroundColor = UIColor.clear
                    self.circleDigit1.layer.borderColor = UIColor.white.cgColor
                    self.circleDigit2.layer.borderColor = UIColor.white.cgColor
                    self.circleDigit3.layer.borderColor = UIColor.white.cgColor
                    self.circleDigit4.layer.borderColor = UIColor.white.cgColor
                    self.circleDigit5.layer.borderColor = UIColor.white.cgColor
                    self.circleDigit6.layer.borderColor = UIColor.white.cgColor
                    
                    
                }
                DispatchQueue.main.asyncAfter(deadline: .now() + 1.5) {
                    self.PINTextField.isUserInteractionEnabled = true
                    self.errorLabel.alpha = 1
                }
                
                self.PINTextField.text?.removeAll()
            // PIN is correct
            } else {
                // store data in scenario specific database collection
                storeUserData(userTransactionRecipient: transactionRecipientPublic, userTransactionIBAN: transactionIBANPublic, userTransactionPurpose: transactionPurposePublic, userTransactionAmount: String(transactionAmountPublic.dropLast(2)))
                
                // do something if PIN is correct...
                self.PINTextField.isUserInteractionEnabled = false
                errorLabel.alpha = 0
                
                
                print("Correct PIN. Start animation")
                print(appPINPublic)

                
                let blueColor = UIColor.init(red: 21/255, green: 65/255, blue: 115/255, alpha: 1)
                circleDigit1.backgroundColor = blueColor
                circleDigit1.layer.borderColor = UIColor.clear.cgColor
                circleDigit2.backgroundColor = blueColor
                circleDigit2.layer.borderColor = UIColor.clear.cgColor
                circleDigit3.backgroundColor = blueColor
                circleDigit3.layer.borderColor = UIColor.clear.cgColor
                circleDigit4.backgroundColor = blueColor
                circleDigit4.layer.borderColor = UIColor.clear.cgColor
                circleDigit5.backgroundColor = blueColor
                circleDigit5.layer.borderColor = UIColor.clear.cgColor
                circleDigit6.backgroundColor = blueColor
                circleDigit6.layer.borderColor = UIColor.clear.cgColor
                
                self.PINTextField.text?.removeAll()
                
                let screenSize: CGRect = self.view.bounds
                
                let animatedRadius = 50.0
                //let screenCentered = CGRect(x: self.view.bounds.midX, y: self.view.bounds.midY, width: animatedRadius, height: animatedRadius)
                
                let myView = SpinnerView(frame: CGRect(x: screenSize.width/2 - ( animatedRadius * 0.5), y: screenSize.height-(_kbSize.height/1.2), width: 50, height: 50))
                self.view.addSubview(myView)
                
                let seconds = 2.5 // 0.8
                DispatchQueue.main.asyncAfter(deadline: .now() + seconds) {
                    // Put your code which should be executed with a delay here
                     
                    let vc = self.storyboard?.instantiateViewController(identifier: "SendVC") as! FinalSendViewController
                    vc.modalPresentationStyle = .fullScreen
                    self.present(vc, animated: true)
                    
                }
            }
        }
    }
    
    /*  UIKeyboardWillShowNotification. */
        @objc internal func keyboardWillShow(_ notification : Notification?) -> Void {
            
            if let info = notification?.userInfo {

                let frameEndUserInfoKey = UIResponder.keyboardFrameEndUserInfoKey
                
                //  Getting UIKeyboardSize.
                if let kbFrame = info[frameEndUserInfoKey] as? CGRect {
                    
                    let screenSize = UIScreen.main.bounds
                    
                    //Calculating actual keyboard displayed size, keyboard frame may be different when hardware keyboard is attached (Bug ID: #469) (Bug ID: #381)
                    let intersectRect = kbFrame.intersection(screenSize)
                    
                    if intersectRect.isNull {
                        _kbSize = CGSize(width: screenSize.size.width, height: 350) // default keyboard height = 350
                    } else {
                        _kbSize = intersectRect.size
                    }
                    print("Your Keyboard Size \(_kbSize)")
                    print(_kbSize.height)
                    //let rectCG = CGRect(x: 0, y: 0, width: 0, height: _kbSize.height)
                    //continueButton.bottomAnchor.constraint(equalTo: view.bottomAnchor, constant: -(_kbSize.height)-20).isActive = true
                    d1.bottomAnchor.constraint(equalTo: self.view.bottomAnchor, constant: -(_kbSize.height)-110).isActive = true
                    d2.bottomAnchor.constraint(equalTo: self.view.bottomAnchor, constant: -(_kbSize.height)-110).isActive = true
                    d3.bottomAnchor.constraint(equalTo: self.view.bottomAnchor, constant: -(_kbSize.height)-110).isActive = true
                    d4.bottomAnchor.constraint(equalTo: self.view.bottomAnchor, constant: -(_kbSize.height)-110).isActive = true
                    d5.bottomAnchor.constraint(equalTo: self.view.bottomAnchor, constant: -(_kbSize.height)-110).isActive = true
                    d6.bottomAnchor.constraint(equalTo: self.view.bottomAnchor, constant: -(_kbSize.height)-110).isActive = true
                }
            }
            
            
        }
    
    @IBAction func cancelButton(_ sender: Any) {
        dismiss(animated: true)
    }
    
}
